define(['angular', 'app', 'TrackersFHIRService'], function (angular, app) {
    'use strict';

    app.service('FitnessMainFHIRService', function (TrackersFHIRService) {
        var emptyActivityResource = {
            meta: {
                tag: [
                    {
                        'system': 'https://wiki.mobilehealth.DOMAIN.EXT/display/PGDMS/Client+Provenance+Mapping',
                        'code': 'REDACTED',
                        'display': 'VA FitHeart'
                    }
                ],
            },
            code: {coding: [{system: 'http://loinc.org',code: '55409-7',display: 'Exercise Tracking Panel'}]
            },
            extension: [
                {
                    'url': 'physical-activity-category',
                    'valueString': 'goal'
                },
                {
                    'url': 'steps',
                    'valueString': ''
                },
                {
                    'url': 'progress',
                    'valueInteger': 0
                },
                {
                    'url': 'activeFlag',
                    'valueString': 'false'
                },
                {
                    'url': 'startDate',
                    'valueString': ''
                },
                {
                    'url': 'endDate',
                    'valueString': ''
                }
            ],
            component: [

                {
                    code: {coding: [{system: 'http://loinc.org',code: '55411-3',display: 'Exercise Duration'}]},
                    valueQuantity: {unit: "minutes"},
                },
                {
                    code: {coding: [{system: 'http://loinc.org',code: '55412-1',display: 'Exercise Distance'}]},
                    valueQuantity: {unit: "miles"},
                },
                {
                    code: {coding: [{system: 'http://snomed.info/sct',code: '74008-4',display: 'Exercise Intensity'}]},
                    valueString: "Easy",
                },
                {
                    code: {coding: [{system: 'http://loinc.org',code: '73985-4',display: 'Exercise Activity'}]},
                    valueString: "Cycling",
                }

            ]
        }








        return angular.extend({}, angular.copy(TrackersFHIRService), {
            code: 'http://loinc.org|55409-7',
            supportsLatest: true,


            buildResource: function (ngModel) {
                TrackersFHIRService.buildResource(ngModel);



                ngModel.component = ngModel.component.map(function (item) {

                    // convert string numbers back to regular int
                    if (item.hasOwnProperty('valueQuantity')) {
                        item.valueQuantity.value = parseInt(item.valueQuantity.value);
                    }
                    return item;
                });

                return ngModel;
            },

            createEmpty: function () {
                var emptyResource = angular.copy(emptyActivityResource);

                return angular.extend({}, TrackersFHIRService.createEmpty(), emptyResource);
            },

            transformItem: function (item) {
                TrackersFHIRService.transformItem(item);


            }
        });
    });
});